-----------------------------------------------------------------------------
--                                                                         --
-- Copyright (c) 1994 by Altera Corp.  All rights reserved.                --
--                                                                         --
--                                                                         --
--  Description:  This file contains macro function A_8MCOMP               --
--                                                                         --
--                                                                         --
--                                                                         --
-----------------------------------------------------------------------------
library pack1076;
use pack1076.pack1076.all;

library synth;
use synth.stdsynth.all;

entity A_8MCOMP is
	port (A7, A6, A5, A4, A3, A2, A1, A0 : in VLBIT;
	      B7, B6, B5, B4, B3, B2, B1, B0 : in VLBIT;
	      ALTB, AEQB, AGTB : out VLBIT;
	      AEB7, AEB6, AEB5, AEB4, AEB3, AEB2, AEB1, AEB0 : out VLBIT);
end A_8MCOMP;


architecture BEHAVIOR of A_8MCOMP is
        constant SIZE : integer := 7;
        signal ABUS : VLBIT_VECTOR(SIZE downto 0);
        signal BBUS : VLBIT_VECTOR(SIZE downto 0);
        signal AEBBUS: VLBIT_VECTOR(SIZE downto 0);
begin
        ABUS <= (A7&A6&A5&A4&A3&A2&A1&A0);
        BBUS <= (B7&B6&B5&B4&B3&B2&B1&B0);
	process(ABUS , BBUS)
	begin
		if ABUS > BBUS then
			AGTB <= '1';
			ALTB <= '0';
			AEQB <= '0';
		elsif ABUS = BBUS then
			AEQB <= '1';
			AGTB <= '0';
			ALTB <= '0';
		elsif ABUS < BBUS then
			ALTB <= '1';
			AEQB <= '0';
			AGTB <= '0';
		end if;
	end process;

	process(ABUS ,BBUS)
	begin
		for i in 7 downto 0 loop
			if ABUS(i) = BBUS (i) then
				AEBBUS(i) <= '1';
			else AEBBUS(i) <= '0';
			end if;
		end loop;
	end process;

        AEB0 <= AEBBUS(0);
        AEB1 <= AEBBUS(1);
        AEB2 <= AEBBUS(2);
        AEB3 <= AEBBUS(3);
        AEB4 <= AEBBUS(4);
        AEB5 <= AEBBUS(5);
        AEB6 <= AEBBUS(6);
        AEB7 <= AEBBUS(7);

end BEHAVIOR;

